/* this do file contains the following programs


nsm_after_interview.ado  -> this program manages the data after an interview is completed, adds new people to the network
		and updates the network data
nsm_sample_field.ado --> this program draws the next (nominated) person to interview, and puts them in nsm_queue
load_data.ado --> this program creates the excel sheets from the stata data.
plotigraph.ado --> this program runs R to plot the network graphs
practice_interview.ado  --> this program draws an practice interview to test everything.

the following globals need to be set before running NSM (see the handbook and/or test_nsm_4seeds.do)
globals:
$test  -- 1 or 0 .  1 indicates that NSM is in test model 
$network_data -- only used in test mode.  Indicates the network that is being sampled
$sample_data -- the sampled network data
$datalog -- the name of the data log
$ids -- the list of partially identifying id variables (i.e., parital name & partial phone #) 
$key_y -- the key dependent variable 1/0 ...NSM will keep track of this during the sampling
$y  -- a short (1-3) list of variables to keep in the data 


*/

// Version 1, 5-28-2017
/*
notes: 
setting the macro test=1 runs NSM in test mode, to illustrate how the program works
 (to conduct simulated sampling on a known network, use the Stata-Mata version of NSM)
to run NSM interactively in the field ("field mode"), make sure the macro test is not equal to 1
i.e.: run the following line:
global test=0 

in field mode, the arguments are the line numbers of the cases where contact information was collected

the following macros are expected:
number : the interview #, (requested below)



*/


// initialize some things
// first create the e_fid and f_fid globals

global fid=""
foreach l in $id {
	global fid="f_`l' $fid "
	}
global eid=""
foreach l in $id {
	global eid="e_`l' $eid "
	}

// create the $fy global	
global fy=""
foreach l in $y {
	global fy="f_`l' $fy "
	}

	
// now, backup the key data files up so that the survey and be recreated if it is accidentally overwritten	
if ${backup}==1 {
	global dir : pwd
	! mkdir "backup $S_DATE""
	local dir2="backup $S_DATE"
	local dir3="${dir}\\`dir2'"
	di "`dir3'"
	foreach data in nodesheet interviewsheet nsm_queue $sample_data $datalog {
		! copy /Y `data'.dta "`dir3'\\`data'.dta"
			}
	}

//************************************************************* nsn_after_interview**********************************************

capture prog drop nsm_after_interview
prog define nsm_after_interview
// in field mode, the arguments are the line numbers of the cases where contact information was collected
local newinterview=1
//local k: word count `0'

load_data 1

//global test=1


if ${step}==0 {
	clear
	//qui save temp_nodes, replace emptyok
	}



// first check on how many interviews have been done but not processed
use $datalog, clear
qui sum step
local step=r(max)
use interviewsheet	
global newinterviews=0
if _N>0 {
keep if interview>$step
keep if role==1
global newinterviews=_N	// this is the number of interviews in the interviewsheet that have not benn processed yet
	}
di "# of new interviews in the interviewsheet " $newinterviews
di "if 0, and in test mode, interview the next case in the sampling queue"	
// part 1 : "interview" the next respondent in the sampling queue

if (${test}==1 & ${newinterviews}==0) | ( ${newinterviews}>0 ) { // this is only run if NSM is in "test mode"
	// increase the step by 1 , as we are going to enter data from 1 interview
	use ${datalog}, clear
	qui sum step
	global step=1+r(max)
		}

// "interview" block ->update contact & network data for auto mode
if ${test}==1 & ${newinterviews}==0 {  // this is only run if NSM is in "test mode"



di "interview #  $step "
use nsm_queue, clear

qui keep if queuepos==$step
global intvid=id  // the id of the current respondent--> intvid is the id of the person who is being interviewed
global method=method
tempfile temp
qui save "`temp'", replace


use "`temp'", clear	
if method==0 {  // if this is a seed, we want to add a case to the network for this person (so they will be included in the network statistics
	capture drop interview
	gen interview=$step
	keep $ids $y id intvnum interview refused contact_info 
	foreach var of varlist id $ids  $y intvnum interview refused contact_info {
		rename `var' f_`var'
		qui gen e_`var'=f_`var'  // the seed cases "refer" each other
		}
	qui gen f_csr=1  // seeds start with f_csr=1	
	append using ${sample_data}
	qui save ${sample_data}, replace
	}
use "`temp'", clear	
keep id $ids method intvnum $y
order intvnum id
gen interview=$step
append using interview_list  // update the interview_list data
sort interview
qui save interview_list, replace
use "`temp'", clear

gen role=1  // the respondent
keep id ${ids} role intvnum $y
local e_intvnum=intvnum

tempfile temp
qui save "`temp'", replace


tempfile temp2
qui save "`temp2'", replace
	
//qui gen sampled=f_sampled

// if running in test/auto mode, get contact info on up to 3 alters
// in field mode, this is done during the interview
//if sampled[1]==0 {  // if the respondent has been sampled for the first time
 // note that if you get sampled a second time, no new interview takes place...(sampling with replacement)...but the # of times 
     // you have been sampled goes up by 1
local newinterview=1
di "this is the person who is being interviewed"
list id ${ids} intvnum

keep ${ids} intvnum
rename intvnum e_intvnum
foreach var in $ids {
	capture drop e_`var'
	rename `var' e_`var'
	}
capture drop sampled
capture drop _merge
qui merge 1:m ${eids} using ${network_data}, keep(1 3)
capture drop _merge
capture drop sampled
capture drop id

gen interview=$step
gen f_intvnum=$step
//set trace on
// get csr, sampled, and contactinfo for these alters
//gen sampled=0
qui save interview_${step}, replace

keep f_* interview 
rename f_* *
di " "
di "these are his/her contacts"

list

global number=$step

gen role=2 // contacts
keep $ids intvnum role $y
	
append using "`temp2'"
sort role
capture drop sampled
qui gen s=1
qui save nodes_${step}, replace
capture drop s
qui gen interview=$step
qui gen contact_info=1
di " "
di "interview data"
order interview role intvnum $ids $y
list

append using interviewsheet
sort interview role
qui save interviewsheet, replace 
qui export excel using interviewsheet, first(var) replace

global newinterviews=1
}





//if `newinterview'==1 {  // both test and field modes run this part.  `newinterview' is for test mode (it indicates that 
if ${newinterviews}>0 {
	// the current respondent is being interviewed for the first time.


// first bring in the new alters
use interviewsheet, clear
keep if interview==$step
di " "
di "this is the data from interview $step "
list 
qui gen s=1

di "now we are adding it to the nodesheet"
qui save current_interview, replace
	
use nodesheet, clear	
qui append using current_interview


// id generation section /*********************************************/
// this block updates the id.  These id's are crucial for the construction of the network
// the variable s allows alters with the same $id to be differentiated
// for example  "1234 w , s=1" will have a different id than "1234 w, s=2"
// the s variable can be modified in the nodesheet in Stata or Excel
// or you can use a separate program in Stata to do this
qui sort $ids s interview intvnum
qui qby $ids s interview intvnum: keep if _n==1
// update the ids
qui tempfile temp
qui save "`temp'", replace
capture drop id
sort $ids s intvnum
qby $ids s : keep if _n==1
sort intvnum $ids
gen id=_n
sort id
order id
keep $ids s id $y
if _N<20 {
di " "
di "list if N<20 "
list
}
qui save current_ids, replace  // these are the current id's for the data


// in this section, the program updates the id's on the nodesheet data
// start section
// the nodesheet data preserves a separate case for each instance of a particular person (differentiated by intvnum)
// this is so that these cases can be separated by the s variable at the researchers / or algorithm's discretion
// in the case of two or more people with the same $ids ($ids = the set of variables collected to differentiate people) 
tempfile temp2
qui save "`temp2'", replace
use "`temp'", clear
if _N<20 {
di " "
di "list if N<20 "
list
}
qui  capture drop id
qui merge m:1 $ids s using "`temp2'"
sort id
drop _merge
qui recode refused .=0
qui recode contact_info .=1
order id interview intvnum $ids s 
sort id interview intvnum
if _N<20 {
di " "
di "list if N<20 "
list
}
qui save nodesheet, replace //update the nodesheet
qui export excel using nodesheet, first(var) replace  // export it to excel
// end section




// this section adds the new ids to the network data
// start section
keep id $ids intvnum // intvnum differeniates nodes in the network
sort $ids intvnum 
qby $ids intvnum: keep if _n==1 // *** note this assumes that this is unique (can't have two people with the same id's on the 
	// same interview
sort id
foreach var in $ids intvnum id {
	rename `var' e_`var'
	}
qui save e_temp, replace
rename e_* f_* 
qui save f_temp, replace
// ok, now update the network data
di "updating the network data"
use nodesheet if interview==$step, clear
// get the alters first
keep if role==2  // the referrals (alters)
keep id $ids intvnum interview  $y contact_info refused
foreach var of varlist id $ids  $y intvnum interview refused contact_info {
		rename `var' f_`var'
	}
tempfile temp
qui save "`temp'"
use nodesheet if interview==$step, clear
// get the ego first
keep if role==1  // the respondent (ego)
keep id $ids intvnum interview  $y contact_info refused
foreach var of varlist id $ids $y intvnum interview refused contact_info {
		rename `var' e_`var'
	}
cross using "`temp'"
di "  "
di "these edges will be added to the network"
 list e_id $eids e_intv e_y f_id $fids f_intv f_y

foreach var in csr noms sampled {
	gen f_`var'=0
	}
foreach var in sampled {
	gen e_`var'=0
	}

append using ${sample_data}
// update the ids
drop e_id f_id
capture drop _merge
qui merge m:1 $eids e_intvnum using e_temp, keep(1 3)

capture drop _merge
qui merge m:1 $fids f_intvnum using f_temp, keep(1 3)

bysort e_id f_id: drop if _n>1  // remove duplicate cases

drop if f_id==.

mkmat f_id if e_id==$intvid, mat(fid_list)
//mat lis fid_list
local j=rowsof(fid_list)
local i=1
while `i'<= `j' {
	local h=fid_list[`i',1]
	//di "updating f_noms for f_id = `h' "
	qui replace f_noms=f_noms+1	if f_id==`h'
	local i=`i'+1
	}

recode f_sampled .=0
qui replace f_sampled=f_sampled+1 if f_id==$intvid  // update f_sampled for the node that is was just sampled
 // in the revealed network data, f_sampled indicates whether an alter was sampled 
di "this is the person who was just interviewed"
list e_id f_id e_sampled f_sampled if f_id==$intvid
recode e_sampled .=0
recode f_sampled .=0
egen max_f_sampled=max(f_sampled), by(f_id)
qui replace f_sampled=max_f_sampled
drop max_f_sampled

di "$intvid"
qui replace e_sampled=e_sampled+1 if e_id==$intvid  // update sampled for the node that is was just sampled--> sampled is for the ego
egen max_e_sampled=max(e_sampled), by(e_id)
replace e_sampled=max_e_sampled
drop max_e_sampled

di "these are the updated parts of the network based on the last interview"
list e_id f_id e_sampled f_sampled if e_id==$intvid
capture drop sdsamp
qui egen sdsamp=sd(e_sampled), by(e_id)  // this is just to double check on the accuracy of this data...it should be the same for all nodes with the same id
sum sdsamp
if r(mean)~=0 {
	// asdf
	}
	
capture drop max_contact
qui egen max_contact=max(f_contact_info), by(f_id)
qui replace f_contact_info=1 if max_contact==1
capture drop max_contact
capture drop _merge

if _N<50 {
di "list the network if it has less than 50 edges"
  list e_id $eids e_intv f_id $fids f_intv
	}
capture drop _merge
qui save ${sample_data}, replace  // update the sample data


if ${test}~=1 {  
	qui save "backup_${sample_data}_${number}", replace  // save a backup of the full data as of the current interview #
	}

// end section


// this section takes the updated network data and adds sampled and quepos to the nodesheet
// "sampled" indicates the # of times a node has been sampled
// "quepos" is the node's position in the current sampling queue
use ${sample_data}, clear
keep f_id f_sampled
gsort f_id -f_sampled
qby f_id: keep if _n==1
foreach var in id sampled {
	rename f_`var' `var'
	}
tempfile temp
qui save "`temp'", replace
use nsm_queue, clear
keep id queuepos
gsort id -queuepos
qby id: keep if _n==1
tempfile temp2
qui save "`temp2'", replace
use nodesheet, clear
capture drop _merge
capture drop sampled
qui merge m:1 id using "`temp'"
capture drop _merge
capture drop queuepos
qui merge m:1 id using "`temp2'"
capture drop _merge
qui save nodesheet, replace //update the nodesheet
qui export excel using nodesheet, first(var) replace  // export it to excel
// end section



// now, update the data log
use ${sample_data}, clear
qui bysort f_id: keep if _n==1
qui sum f_sampled
local interviews=r(sum)
di _newline(4) 
di ""
di "Number of interviews so far (sampling with replacement): $interviews"
di "current step number : $step "
// next, calculate the current size of the network
  // and plt2nom
use ${sample_data}, clear
capture drop n
qui gen n=1
//list
collapse (sum) n (max) f_y f_csr f_sampled f_contact_info, by(f_id)
local netsize=_N
di "Current size of the network: $netsize "

/*  // next revision: use resampling weights
gen wgt=f_sampled/f_csr
//gen wgt=1/f_csr
sum f_y [w=wgt]
local ymean_wgt=r(mean)
di "weighted mean:  `ymean_wgt' "
*/

qui gen plt2nom=n<2 & f_sampled==0
qui sum plt2nom
local plt2nom=r(mean)
di "current plt2nom : $plt2nom "
qui sum f_contact_info
local contact_info=r(sum)

use nodesheet, clear
sort id
keep if sampled>=1 & sampled~=.
qby id: keep if _n==1
sum $key_y 
local ymean=r(mean)

use interview_list, clear
if _N<50 {
	di "this is the list of interviews"
	di "display if the number of interviews is less than 50"
	list
	}
drop if method==0
gen search=method==1
qui sum search
local search=r(mean)
	
clear
set obs 1
gen ymean=`ymean'

gen plt2nom=`plt2nom'
gen netsize=`netsize'
gen est_pop=netsize/(1-plt2nom)
gen search_mode=`search'
gen interview=$step
gen step=$step
//gen ymean_wgt=`ymean_wgt'

label var ymean "the current raw (unweighted) mean of the dv among sampled cases"
//lab var ymean_wgt "the current weighted mean of the dv among sampled cases"
lab var plt2nom "the proportion of nominated cases with less than 2 nominations"
lab var netsize "the current size of the network"
lab var est_pop "the current estimated population size"
lab var search_mode "the proportion of non-seed cases sampled using the search mode"
gen evensampling=.
append using $datalog
sort interview
order interview netsize plt2nom est_pop ymean 

// check to see if even sampling should be turned on
if $step>10 {
	local dif=netsize[${step}]-netsize[${step}-5]
	di "increase in netsize over the last 5 interviews = `dif' "
	if (`dif'==0)| (netsize[${step}]>=200) {
		global evensampling=1
		}
	else if (`dif'>0 )& (netsize[${step}]>=200) {
		global evensampling=0
		}
	
	}

capture drop if interview==.
qui replace evensampling=$evensampling if evensampling==.	
qui save $datalog, replace
	
capture drop step
di " "
di "this is a list of the data log, that keeps track of the statistics of the sample"
list
// end section

if ${step}<250 & mod(${step},10)==0 { // do this every 10 steps 
	plotigraph
	}
	

if ${step}>=250 & mod(${step},50)==0 { // do this every 50 steps after the 250th interview
	plotigraph
	}
	
	
}
// end "interview" block

//list fid f_phone f_first contact_info id if interview==$number

//nsm_datalog

// update # of nominations
use ${sample_data}, clear
capture drop nominations
gen nominations=1
collapse (sum) nominations, by(f_id)
rename f_id id
qui save temp_nominations, replace

clear

load_data 2

/*  // not necessary ?
use ${datalog}, clear  // now update the data log
	sum step
	global step=1+r(max)
	save $datalog, replace  
*/
end

//************************************************************* nsn_sample_field************************************************************


capture prog drop nsm_sample_field
program define nsm_sample_field

// Version 1 5-28-17

// part 3: select then next respondent to put into the sampling queue


load_data 1

use ${datalog}, clear
sum step
//global step=r(max)+1
di "number of interviews processed on the data log  " $step



// make sample statistics
use ${sample_data}, clear
qui bysort e_id: keep if _n==1
qui sum e_sampled
global interviews=r(sum)
di _newline(4) 
di "Sampling to add a new node to the sampling queue"
di ""
di "Number of interviews so far (sampling with replacement): $interviews"
di "current step number : $step "

// next, calculate the current size of the network
  // and plt2nom
use ${sample_data}, clear
capture drop n
qui gen n=1
//list
collapse (sum) n (max) f_csr f_sampled f_contact_info, by(f_id)
global netsize=_N
di "Current size of the network: $netsize "

qui gen plt2nom=n<2 & f_sampled==0
qui sum plt2nom
global plt2nom=r(mean)
di "current plt2nom : $plt2nom "
qui sum f_contact_info
global contact_info=r(sum)

// calculate the esr.  see Mouw and Verdery p.218
// note this has been adjust slightly to work with networks with less than 100 nodes
qui sum f_sampled
//egen maxcsr=max(f_csr), by(f_id)
local ls=r(min)
//gen wgt=f_sample/f_csr
sum f_sampled if f_sampled<=`ls' 
if r(N)>0 {
	keep if f_sampled<=`ls'
	local n=(int(_N)/2)+1
	di `n'
	if `n'>100 { 
		local n=100
		}
	sort f_csr
	//list f_csr
	keep if _n<=`n'
	sum f_csr
    global esr=r(max)
}

// now, select the next person to interview
global method=1 // search mode
if ${step}<4  {
	global method=2 // list mode
	}

if ${step}>50 & ${plt2nom}<.4 {
	global method=2 // list mode
	}
//global method=2  // temp*****	
di "method for next selection (1=search mode, 2=list mode): $method "	


// search mode block
if ${method}==1 {
 // need information on sampled nodes: number of alters, # of alters with less than 2 nominations
 // first, update information
 di "running method 1"

 // step 1: select a sampled node first
 use ${sample_data}, clear
 qui drop if e_id==f_id  // this is only the case for initial seeds
 
 // this block gets rid of nodes currently in the queue to be interviewed 
 capture drop _merge	
	tempfile temp
	qui save "`temp'", replace
	use nsm_queue, clear
	keep id queuepos
	rename id f_id
	qui keep if queuepos>=$step
	if _N>0 {
	tempfile temp2
	qui save "`temp2'", replace
	use "`temp'"
	qui merge m:1 f_id using "`temp2'", keep(1 3)  // remove nodes currently in the sampling queue
	capture drop znotinque
	gen znotinque=_merge==1
	capture drop _merge
	//tab notinque
		}
	else if _N==0 {
		use "`temp'", clear
		
		capture drop znotinque
		gen znotinque===1
	
		}
 // end block
 
 capture drop lt2
 capture drop n
 gen lt2=f_noms<2 & f_sampled==0
 gen n=1
 gen eligible=f_sampled==0 & f_contact_info==1 & znotinque==1
 qui save temp_method2, replace
 collapse (sum) n lt2 eligible, by(e_id)
 gen tailprob=1-binomialtail(n,lt2,$plt2nom)
 keep if eligible>0 & tailprob>0
 if _N>0 {
 gsort -tailprob
 qui drop if _n>5
 egen tot=sum(tailprob)
 gen ctot=sum(tailprob)
 gen p=ctot/tot
 lab var p "prob of selecting, first step"
 gen weight=tailprob/(eligible*tot)
 qui save temp_method2b, replace
 qui gen p_prev=p[_n-1]
 recode p_prev .=0
 local u=uniform()
 di `u'
 //list e_id p p_prev tailprob ctot tot eligible
 qui keep if `u'>p_prev & `u'<=p
 di "selected node " e_id 
 keep e_id
 // step 2: select an eligible alter of the step 1 node
 qui merge 1:m e_id using temp_method2, keep(1 3)
 keep if eligible==1
 gen zprob=1
 if _N>0 {
 egen tot=sum(zprob)
 gen ctot=sum(zprob)
 gen p=ctot/tot
 lab var p "prob of selecting, second step"
 gen p_prev=p[_n-1]
 recode p_prev .=0
 local u=uniform()
 di `u'
 //list f_id e_id p p_prev zprob ctot tot eligible f_noms $fy
 qui keep if `u'>p_prev & `u'<=p
 di "selected node " f_id 
 // add the node to the sampling queue
 di "selected node, adding to sampling queue " f_id[1]
	list $fids
	qui keep f_id f_contact_info f_sampled f_refused f_intvnum e_id $fids $fy
	foreach var in id $ids sampled contact_info intvnum refused $y {
		rename f_`var' `var'
		}
	//rename f_id e_id 
	//rename f_sampled sampled
	gen method=1  // indicates the method used to sample this case
	capture drop queuepos
	append using nsm_queue
	qui sum queuepos
	global quemax=r(max)
	if ${quemax}==. {
		global quemax=0
		}
	qui replace queuepos=${quemax}+1 if queuepos==.
	di "listing current sampling queue"
	//recode f_sampled .=0
	capture drop _merge
	//keep e_id e_sampled queuepos method $fids intvnum
	keep id sampled method queuepos $ids intvnum refused contact_info $y
	list if queuepos>=$step
	qui save nsm_queue, replace

// update the sampling weights
 use temp_method2b, clear
 //list e_id n lt2 eligible weight
 keep e_id weight
 qui merge 1:m e_id using temp_method2, keep(3)
 keep if eligible==1
 //list f_id e_id weight
 keep f_id weight
 collapse (sum) weight, by(f_id)
 capture drop _merge
 qui merge 1:m f_id using ${sample_data}
 qui replace f_csr=f_csr+weight if _merge==3  // merge==3 are cases that were eligible for sampling
 capture drop _merge
 capture drop weight
 qui save ${sample_data}, replace
  }
else if _N==0 {
	global method=2
 	}
 
 
 }
	
else if _N==0 {
	global method=2
	}
 

}

// list mode block
if ${method}==2 {
	use ${sample_data}, clear
	
	if ${step}<5 {
		sort f_phone f_first
		list f_id f_phone f_first f_sampled f_contact_info
		}
	keep f_id f_contact_info f_sampled f_refused f_csr f_intvnum e_id $fids $fy 
	capture drop maxcsr
	qui egen maxcsr=max(f_csr), by(f_id)
	bysort f_id: keep if _n==1
	qui drop if e_id==f_id
	qui keep if f_contact_info==1  // can only sample cases with contact info
	qui drop if f_id==$intvid   // do not resample the current case
	if ${evensampling}==1 {  // if even sampling is turned on
		// if even sampling is turned on, do not sample cases that have already been sampled provided there are unsampled cases
		qui sum f_sampled
		local ls=r(min)
		//capture drop wgt
		//gen wgt=f_sample/maxcsr
		//sum if wgt<=${esr} & f_sampled<=`ls'
		sum maxcsr if maxcsr<=${esr} & f_sampled<=`ls'
		if r(N)>0 {
		keep if maxcsr<=${esr} & f_sampled<=`ls'
			}
		}
	
	if ${netsize}<50 {
		qui drop if f_sampled>=1
		}
	capture drop _merge	
	tempfile temp
	qui save "`temp'", replace
	use nsm_queue, clear
	keep id queuepos
	rename id f_id
	keep if queuepos>=$step
	if _N>0 {
	tempfile temp2
	qui save "`temp2'", replace
	use "`temp'"
	qui merge m:1 f_id using "`temp2'", keep(1)  // remove nodes currently in the sampling queue
	}
	else if _N==0 {
		use "`temp'"
		}
	keep f_id f_sampled $fids f_contact_info f_refused	f_intvnum $fy
	
	qui save temp1, replace
	global sr=1/_N
	// update cumulative sampling rate
	capture drop _merge
	qui merge 1:m f_id using ${sample_data}
	qui replace f_csr=f_csr+${sr} if _merge==3  // merge==3 are cases that were eligible for sampling
	capture drop maxcsr
	qui egen maxcsr=max(f_csr), by(f_id)
	qui replace f_csr=maxcsr
	capture drop _merge
	capture drop maxcsr
	qui save ${sample_data}, replace
	
	// add the selected node to the sampling queue
	use temp1, clear
	capture drop u
	qui gen u=uniform()
	sort u
	qui keep if _n==1
	di "selected node, adding to sampling queue.  Id = " f_id[1]
	capture drop u
	
	foreach var in id $ids sampled contact_info intvnum refused $y {
		rename f_`var' `var'
	
		}
	
	qui list 
	//qui keep f_id f_sampled $fids 
	//rename f_id e_id 
	//rename f_sampled sampled
	capture drop queuepos
	gen method=2
	append using nsm_queue
	qui sum queuepos
	global quemax=r(max)
	if ${quemax}==. {
		global quemax=0
		}
	qui replace queuepos=${quemax}+1 if queuepos==.
	di "listing current sampling queue"
	//recode f_sampled .=0
	capture drop _merge
	keep id sampled method queuepos $ids intvnum refused contact_info $y
	
	qui save nsm_queue, replace
	// list
	}
di "step $step "	

load_data 2

end

capture prog drop load_data
prog define load_data
args a

// this program makes sure the excel sheets and the stata data files are the same at the start
	//  and the end of the programs
// for the folliwng files:
// nodesheet, interviewsheet, nsm_queue
clear
if $step>0 {
if `a'==1 {  // load into Stata
	foreach name in interviewsheet nodesheet nsm_queue interview_list {
	qui import excel using "`name'", first clear
	qui save "`name'", replace
		}
	}

if `a'==2{  // export from Stata to Excel
	foreach name in interviewsheet nodesheet nsm_queue interview_list $datalog {
	qui use "`name'", clear
	qui export excel using "`name'", first(var) replace
			}
	}
	}

end


capture prog drop plotigraph
program define plotigraph
// save data to be read by R 
use ${sample_data}, clear
qui drop if e_id==f_id
qui keep e_id f_id 
order e_id f_id
//saveold ${rdir}\test_edges_r, replace version(12)
qui saveold test_edges_r${step}, replace version(12)

use nodesheet, clear
sort id intvnum
qby id: keep if _n==1
qui sum id
order id

qui saveold test_nodes_r${step}, replace version(12)

if "${netname}"=="" {
	global netname="nsm sample"
	}
clear
set obs 1
gen name="${netname}"
qui save netname, replace	
if ${pc}==1 {
	//shell "C:\Program Files\R\R-3.3.0\bin\Rscript.exe" "nsmgraph.R" $step "${netname}" > out${step}.txt
	shell "${rpath}Rscript.exe" "nsmgraph.R" $step "${netname}" > out${step}.txt
	}
else if ${pc}==2 {  // i.e., mac
	//?????
		}
// also, output the current network data to be read by Gephi
use ${sample_data}, clear
keep e_id f_id e_interview
rename e_id source
rename f_id target 
sum source target
qui export delimited source target using test_edges_gephi, replace
use nodesheet, clear
sort id intvnum
qby id: keep if _n==1
sum id
qui export delimited using test_nodes_gephi, replace

end


capture prog drop practice_interview
prog define practice_interview

di "this program simulates an interview"
di "use the interviewsheet in excel to input the data from the interview"
di "see the example in the training manual"
di "this program is similar to the automatic interviews in the test mode"
di "except that it doesn't automatically update the data after the interview"

load_data 1

// check on the current step
use $datalog, clear
sum step
global step=r(max)+1  // this is interview # for this interview


// check to see if there are people in the queue to be interviewed
use nsm_queue
	if _N<1 {  // add more respondents
		asdf
		nsm_sample_field
		}


di "interview #  $step "
use nsm_queue, clear

qui keep if queuepos==$step
global intvid=id  // the id of the current respondent--> intvid is the id of the person who is being interviewed
global method=method
tempfile temp
qui save "`temp'", replace


use "`temp'", clear
if method==0 {  // if this is a seed, we want to add a case to the network for this person (so they will be included in the network statistics
	capture drop interview
	gen interview=$step
	keep $ids $y id intvnum interview refused contact_info 
	foreach var of varlist id $ids  $y intvnum interview refused contact_info {
		rename `var' f_`var'
		gen e_`var'=f_`var'  // the seed cases "refer" each other
		}
	gen f_csr=1  // seeds start with f_csr=1	
	append using ${sample_data}
	save ${sample_data}, replace
	}
use "`temp'", clear	
keep id $ids method intvnum $y
order intvnum id
gen interview=$step
append using interview_list  // update the interview_list data
sort interview
qui save interview_list, replace
use "`temp'", clear

gen role=1  // the respondent
keep id ${ids} role intvnum $y
local e_intvnum=intvnum

tempfile temp
qui save "`temp'", replace


tempfile temp2
qui save "`temp2'", replace
	
local newinterview=1
di "this is the person who is being interviewed"
list id ${ids} intvnum

keep ${ids} intvnum
rename intvnum e_intvnum
foreach var in $ids {
	capture drop e_`var'
	rename `var' e_`var'
	}
capture drop sampled
capture drop _merge
qui merge 1:m ${eids} using ${network_data}, keep(1 3)
capture drop _merge
capture drop sampled
capture drop id

gen interview=$step
gen f_intvnum=$step

qui save interview_${step}, replace

keep f_* interview 
rename f_* *
di " "
di "these are his/her contacts"

list

global number=$step
//gen interview=${step}
//lab var interview "the interview that R was first nominated"

gen role=2 // contacts
/*
capture drop $ids
foreach var in $ids {
	rename f_`var' `var'
	}
*/
keep $ids intvnum role $y
	
append using "`temp2'"
sort role
capture drop sampled
gen s=1
qui save nodes_${step}, replace
capture drop s
// set trace on
gen interview=$step
gen contact_info=1
di " "
di "interview data in the form it should be entered into the interviewsheet"
di "note if multiple interviews have been completed, update the interview number sequentially on the interviewsheet"
order interview role intvnum $ids $y id contact_info
list, clean noobs
export excel using practice_interview, first(var) replace

end
		
