capture log close
log using test, text replace
di "*************************new log file***********************************************"
clear
prog drop _all
// let's test everything with 4 initial seeds

//set trace off
set more off
mac drop _all
// NSM field version
// the simulated sampling version of NSM is written in Mata so that it runs faster
// this version is written in Stata to be more accessible in the field

// the "test" version runs in auto mode
// select $test=0 to turn auto mode off

global testnetwork=1
if ${testnetwork}==1 {
	global network_data="islands_network"  // this is the test network data
	}
else if ${testnetwork}==2 {
	global network_data="field_test_data"  // this is the test network data
	}

clear
set more off
global step=0  // this means that we are before the first interview, i.e. "step" of the survey
global pc=1  // windows computer
  // 0 = mac
  // 2 = unix
global backup=1  // backs up the data when running nsm_programs.do to a day/month/year specific directory
global test=1  // =1 if you are in test mode (simulated sampling), or 0 if you are not.
//global rdir="C:\papers\r"
global rpath="C:\Program Files\R\R-3.3.0\bin\"

global sample_data="sample_data"  // this is the revealed (sampled) network
global datalog="test_log"  // this keeps track of things
global ids="phone first"  // these are the identifying variables
global fids="f_phone f_first"  // identifying variables for the alters
global eids="e_phone e_first"  // these are the identifying variables
//global node_data="node_data"
global key_y="y"  // the key dependent variable for the summary statistics.
//foreach var in $y {

global y="y"  // a dependent variable...these variables are kept in the data
global fy="f_y"
global ey="e_y"

if "${network_data}"=="field_test_data" {
	global netname="test network "
	}

if "${network_data}"=="islands_network" {
global netname="2-islands network"
global y="y zid"  // a dependent variable...these variables are kept in the data
global fy="f_y f_zid"
global ey="e_y e_zid"
	}
global evensampling=0

do nsm_programs


clear
save ${sample_data}, replace emptyok  // reset the sample data sets
save nsm_queue, replace emptyok
save interview_list, replace emptyok
save interviewsheet, replace emptyok
save nodesheet, replace emptyok
if ${pc}==1 {
! del /f nsm_queue.xls
! del /f nodesheet.xls
! del /f interviewsheet.xls
	}
else if ${pc}==2 {  // i.e., mac
  // ?????
  di "???? delete these files manually until this is fixed"
  di "they should be overwritten below, so it is probably ok"
  //stop
  		}
set obs 1
gen step=0

save ${datalog}, replace
 
load_data 2  // exports to excel to reset the excel sheets

if ${test}~=1 {
	di "stop here if not in test mode"
	di "now follow the directions in Section 5 of the NSM training manaual"
	asdf  // this will stop the program

	}

use ${network_data}, clear
des
list in 1/20

// first, select 4 initial seeds
bysort ${eids}: keep if _n==1
gen u=uniform()
sort u
if "${network_data}"=="islands_network" {
	use $network_data, clear
	bysort e_zid: keep if _n==1
	sort e_zid  // use the first 4 nodes in the first cluster as the seeds
	}
keep if _n<=4  // select 4 people at random
di "the initial seeds are: " 
list $eids 
keep $eids $ey


gen sampled=0
gen intvnum=0 
save temp_seeds, replace
gen phone=e_phone  
gen first=e_first
gen contact_info=1  // there is contact info on this person
foreach var in $y {
	rename e_`var' `var'
	}
gen csr=1
gen noms=0
label var noms "# of times nominated in the sample"
label var csr "current sampling rate for this node"
label var contact_info "contact info available?"
lab var intvnum "the interview # this person was nominated"
list
capture drop _merge
gen refused=0
gen s=1
sort $ids
gen id=_n  // this is just for the seeds

keep $ids s id intvnum refused contact_info $y
//gen interview=0
gen role=1
gen interview=0
save nodesheet, replace 
drop role

gen queuepos=_n
gen method=0 // initial seed
list
save nsm_queue, replace



// ok, now we have 4 seeds in the queue

capture prog drop nsm_test
prog define nsm_test  
args addsteps
// this program conducts a test of the sampling programs
use $datalog, clear
if _N>0 {
sum step
global step=r(max)
}
else if _N==0 {
 global step=0
 }
local j=1
while `j'<=`addsteps' {
//while ${step}<= ${sampsize} {  // samplesize is the desired sample size

if $step > 0 {
use ${sample_data}, clear
qui bysort e_id: keep if _n==1
qui sum e_sampled
di _newline(4) 
di "Getting the next respondent from the sampling queue"
di ""
di "Number of interviews that have been entered into the data (sampling with replacement): $interviews"
di "steps completed : $step "
clear
}
	//if ${test}~=1 {
	//	di "turn test on"
	//	exit(1)
	//	}
	nsm_after_interview
	// check to see if more respondents need to be added to the queue
	use nsm_queue
	keep if queuepos>$step
	if _N<=1 {  // add more respondents
		nsm_sample_field
		}
	
	local j=`j'+1
}


use $datalog, clear
capture drop step
list

end

if ${test}==1 {
	nsm_test 30		
}
log close
